define(['angular', 'app', 'moment'], function (angular, app, moment) {
	"use strict";

	app.filter('navItemDate', function(dateFilter) {
		return function(dt) {
			var date = new Date(dt),
				now = new Date(),
				entryDate = date.getDate(),
				nowMinusOneDay = parseInt(moment().subtract(1, 'days').format('D'));
				
			if (date.getFullYear() !== now.getFullYear() ||
				date.getMonth() !== now.getMonth() ||
				date.getDate() !== now.getDate()) {
				if (entryDate === now.getDate() - 1 || entryDate === nowMinusOneDay) {
					return "Yesterday";
				}
				else {
					return dateFilter(date, 'MM/dd/yyyy');
				}
			} else {
				return "Today";
			}
		};
	});
});